/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import jclass.beans.GroupPanel;
import jclass.table3.BeanFileDataSource;
import jclass.table3.DataWrapper;
import jclass.table3.EditableTableData;
import jclass.table3.EditableVectorDataSource;
import jclass.table3.JCCellRange;
import jclass.table3.JCTblRevConverter;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.TableData;
import jclass.table3.TableDataEvent;
import jclass.table3.TableDataListener;
import jclass.table3.VectorDataSource;
import jclass.table3.bean.DataSourceCellRenderer;
import jclass.table3.bean.TextDialog;
import jclass.util.JCVector;

public class DataEditor
extends SeriesEditor
implements ActionListener,
ItemListener,
FocusListener,
TableDataListener {
    private Checkbox chbxTable;
    private Checkbox chbxFile;
    private TextField textFName;
    private Button buttonColumns;
    private Button buttonClear;
    private Button buttonRows;
    private Button buttonBrowse;
    private Point textDialogLocation;
    private VectorDataSource tableSource;

    public DataEditor() {
        super(0);
        this.tableSource = (VectorDataSource)this.tableView.getDataSource();
        this.updatePixelWidth();
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new DataWrapper(true, 5, 10, "", "", "(00|01|02)(10|11|12)");
        }
        if (this.tableView.getDataSource() != null) {
            this.tableView.getDataSource().removeTableDataListener(this);
        }
        this.tableView.setData((DataWrapper)object);
        super.setValue(object);
        TableData tableData = this.tableView.getDataSource();
        if (tableData != null) {
            tableData.addTableDataListener(this);
        }
        boolean bl = tableData instanceof BeanFileDataSource;
        this.setStateFile(bl);
        if (bl) {
            ((TextComponent)this.textFName).setText(((BeanFileDataSource)tableData).getName());
        }
        this.updateSizePanel();
    }

    public Object getValue() {
        this.tableView.commitEdit(true);
        return this.tableView.getData();
    }

    public String getAsText() {
        return this.getStringValue(this.nl);
    }

    public String getJavaInitializationString() {
        String string = String.valueOf(this.chbxTable.getState() ? "true, " : "false, ") + ((VectorDataSource)this.tableView.getDataSource()).getNumRows() + ", " + ((VectorDataSource)this.tableView.getDataSource()).getNumColumns() + ", " + this.getStringValue("\n      ");
        return "new jclass.table3.DataWrapper(" + string + ")";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object.equals(this.chbxTable) || object.equals(this.chbxFile)) {
            this.changeSource();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonBrowse)) {
            this.browseFile();
            return;
        }
        if (object.equals(this.buttonClear)) {
            this.clearData();
            return;
        }
        if (object.equals(this.buttonColumns) || object.equals(this.buttonRows)) {
            this.editLabels(object.equals(this.buttonRows));
            return;
        }
        if (object.equals(this.textFName)) {
            this.showSource();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        Object object = focusEvent.getSource();
        if (object.equals(this.textFName)) {
            this.showSource();
        }
    }

    public void dataChanged(TableDataEvent tableDataEvent) {
        this.updatePixelWidth();
        this.updatePropertyPanel(null);
    }

    protected void init() {
        super.init();
        this.tableView.setSelectionPolicy(0);
        this.tableView.setAllowCellResize(1);
        this.tableView.setEditable(-998, -998, true);
        this.tableSource = (VectorDataSource)this.tableView.getDataSource();
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.support.firePropertyChange("dataSource", null, this.getValue());
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new DataSourceCellRenderer(this);
    }

    protected Component makePropertyPanel() {
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.chbxTable = new Checkbox("table", checkboxGroup, true);
        this.chbxFile = new Checkbox("file", checkboxGroup, false);
        this.textFName = new TextField(60);
        this.buttonClear = new Button("Clear Cells");
        this.buttonColumns = new Button("Column Labels");
        this.buttonRows = new Button("Row Labels");
        this.buttonBrowse = new Button("Browse");
        GroupPanel groupPanel = new GroupPanel("Data source");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)this.chbxTable, gridBagConstraints);
        groupPanel.add((Component)this.buttonClear, gridBagConstraints);
        groupPanel.add((Component)this.buttonColumns, gridBagConstraints);
        groupPanel.add((Component)this.buttonRows, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this.chbxFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        groupPanel.add((Component)this.textFName, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        groupPanel.add((Component)this.buttonBrowse, gridBagConstraints);
        this.chbxTable.addItemListener(this);
        this.chbxFile.addItemListener(this);
        this.buttonClear.addActionListener(this);
        this.buttonColumns.addActionListener(this);
        this.buttonRows.addActionListener(this);
        this.buttonBrowse.addActionListener(this);
        this.textFName.addActionListener(this);
        this.textFName.addFocusListener(this);
        return groupPanel;
    }

    private void setStateFile(boolean bl) {
        if (bl) {
            this.chbxFile.setState(true);
            this.tableView.setPixelWidth(-998, 33001);
        } else {
            this.chbxTable.setState(true);
            this.tableSource = (VectorDataSource)this.tableView.getDataSource();
            this.updatePixelWidth();
        }
        this.tableView.setEditable(-998, -998, !bl);
        this.setState(!bl);
    }

    private void browseFile() {
        FileDialog fileDialog = new FileDialog(this.findParent(), "Load Data Source", 0);
        fileDialog.setModal(true);
        fileDialog.setFile(this.textFName.getText());
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            ((TextComponent)this.textFName).setText(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            this.showSource();
        }
    }

    private void clearData() {
        this.tableView.setRepaint(false);
        this.tableSource.removeTableDataListener(this);
        int n = 0;
        while (n < this.tableSource.getNumRows()) {
            int n2 = 0;
            while (n2 < this.tableSource.getNumColumns()) {
                this.tableSource.setCell(n, n2, null);
                ++n2;
            }
            ++n;
        }
        this.tableSource.addTableDataListener(this);
        this.updatePixelWidth();
        this.tableView.setRepaint(true);
        this.updatePropertyPanel(null);
    }

    private void updatePixelWidth() {
        int n = 0;
        while (n < this.tableSource.getNumColumns()) {
            boolean bl = this.isEmpty(this.tableSource.getTableColumnLabel(n));
            if (bl) {
                int n2 = 0;
                while (n2 < this.tableSource.getNumRows()) {
                    Object object = this.tableSource.getTableDataItem(n2, n);
                    if (!this.isEmpty(object)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.tableView.setPixelWidth(n, 70);
            } else {
                this.tableView.setPixelWidth(n, 33001);
            }
            ++n;
        }
    }

    private boolean isEmpty(Object object) {
        return object == null || !(object instanceof String) || ((String)object).trim().length() == 0;
    }

    private void editLabels(boolean bl) {
        TextDialog textDialog = new TextDialog(this.findParent(), String.valueOf(bl ? "Row" : "Column") + " Labels");
        String string = bl ? JCTblRevConverter.fromVector((JCVector)this.tableSource.getRowLabels(), '\n') : JCTblRevConverter.fromVector((JCVector)this.tableSource.getColumnLabels(), '\n');
        textDialog.setText(string);
        textDialog.pack();
        if (this.textDialogLocation == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.textDialogLocation = new Point(Math.max((dimension.width - this.getSize().width) / 2, 0), Math.max((dimension.height - this.getSize().height) / 2, 0));
        }
        ((Component)textDialog).setLocation(this.textDialogLocation);
        textDialog.show();
        this.textDialogLocation = textDialog.getLocation();
        if (textDialog.getResult()) {
            string = textDialog.getText();
            if (bl) {
                this.tableSource.setRowLabels(null, string, '\n', false);
            } else {
                this.tableSource.setColumnLabels(null, string, '\n', false);
            }
            this.updatePropertyPanel(null);
        }
    }

    private void changeSource() {
        this.tableView.commitEdit(true);
        boolean bl = this.chbxTable.getState();
        if (bl) {
            if (this.tableView.getDataSource() != null) {
                this.tableView.getDataSource().removeTableDataListener(this);
            }
            if (this.tableSource == null) {
                this.tableSource = new EditableVectorDataSource();
            }
            this.tableView.setDataSource(this.tableSource);
            this.tableSource.addTableDataListener(this);
            this.setStateFile(false);
            this.updateSizePanel();
            this.updatePropertyPanel(null);
            return;
        }
        this.showSource();
    }

    private void setState(boolean bl) {
        this.buttonColumns.setEnabled(bl);
        this.buttonClear.setEnabled(bl);
        this.buttonRows.setEnabled(bl);
    }

    private void showSource() {
        String string = this.textFName.getText().trim();
        this.tableView.commitEdit(true);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BeanFileDataSource beanFileDataSource = new BeanFileDataSource(string, fileInputStream);
            TableData tableData = this.tableView.getDataSource();
            if (tableData instanceof EditableTableData) {
                this.tableSource = (VectorDataSource)tableData;
            }
            this.tableView.setDataSource(beanFileDataSource);
            this.setStateFile(true);
            this.updateSizePanel();
            this.updatePropertyPanel(null);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string.length() == 0) {
                this.errorMessageBox("Please, enter data file name first.");
            } else {
                this.errorMessageBox("Specified data file is not found.");
            }
        }
        catch (IOException iOException) {
            this.errorMessageBox("Specified data file is not valid: " + iOException);
        }
        this.setStateFile(false);
    }

    private String getStringValue(String string) {
        String string2 = "";
        if (this.chbxTable.getState()) {
            VectorDataSource vectorDataSource = (VectorDataSource)this.tableView.getDataSource();
            string2 = String.valueOf(string2) + "\"" + JCTblRevConverter.fromVector((JCVector)vectorDataSource.getRowLabels(), '|') + "\", " + string + "\"" + JCTblRevConverter.fromVector((JCVector)vectorDataSource.getColumnLabels(), '|') + "\", ";
            if (vectorDataSource != null) {
                string2 = String.valueOf(string2) + string + "\"";
                int n = 0;
                while (n < vectorDataSource.getNumRows()) {
                    string2 = String.valueOf(string2) + "(";
                    int n2 = 0;
                    while (n2 < vectorDataSource.getNumColumns()) {
                        if (n2 != 0) {
                            string2 = String.valueOf(string2) + "|";
                        }
                        string2 = String.valueOf(string2) + vectorDataSource.getTableDataItem(n, n2);
                        ++n2;
                    }
                    string2 = String.valueOf(string2) + ")";
                    ++n;
                }
                string2 = String.valueOf(string2) + "\"";
            }
        } else {
            string2 = "\"\", \"\", \"" + this.textFName.getText() + "\"";
            string2 = string2.replace('\\', '/');
        }
        return string2;
    }
}

